(function(exports) {

const combo_tabs_map = { 	
	pwm: 				{combo: 3, tab: 0}, 
	temperature: 		{combo: 4, tab: 1},
	proportional_pwm: 	{combo: 5, tab: 2},
	cable: 				{combo: 6, tab: 3}}
const line_number_map = {"B021_3": 1, "B121_3": 2, "B221_3": 3, "B321_3": 4, "B421_3": 5, "B521_3": 6}

let button_command_xhr = new XMLHttpRequest()

exports.show = function(control_mode)
{
	$("#app_sw_div").append('<h3 id="Heating">Heating</h3>')
	for (let line_number = 1; line_number <= app_sw_config.heat_lines_count; line_number++)
    {
        $("#app_sw_div").append(get_heat_lines_header(line_number))
        $("#app_sw_div").append(get_heat_lines_body(line_number, control_mode[line_number-1]))
    }
    hide_indexes(app_sw_config.hide_fields_indexes, app_sw_config.heat_lines_count)

	show_lines_mode()
}

function show_lines_mode()
{
	if (app_sw_config.is_show_lines_mode)
	{
		let lines_mode_header = $(`<div class="accordion-header">${l100n.localize_string( "Lines Settings")}</div>`)
		let lines_mode_body = $('<div class="accordion-body">')
		let table = $('<table class="line-params-table">')
		table.append(`<tr class="table_header"><td colspan="2">${l100n.localize_string("Lines Settings")}</td></tr>`)
		table.append(common.form_tag_tr_param({name: l100n.localize_string("Lines Mode"), index: 0x500F, sub: 1}))
		lines_mode_body.append(table)

		$("#app_sw_div").append(lines_mode_header)
		$("#app_sw_div").append(lines_mode_body)
	}
}

exports.request_control_mode = function(lines_count)
{
	let query = '/get_od_data.form?'
    for (let number = 1; number <= lines_count; number++)
    {
        if (number > 1) { query += "&"; }
        query += `0x${(0xB021 + app_sw_config.index_multiply*(number-1)).toString(16).toUpperCase()}_3`; //control mode
	}
	return fetch(query)
		.then(response => response.text())
		.then(response_text => common.response_ready(response_text))
}

function hide_indexes(hide_fields_indexes, lines_count)
{   
	if (hide_fields_indexes)
	{
		hide_fields_indexes.forEach(function(item, index, array) 
		{
			if (item.sub === "all") 
			{
				for (let line_number = 1; line_number <= lines_count; line_number++)
				{
					let index = Number(item.index).toString(16).toUpperCase()
					let sub = line_number			
					//console.log(`.tag[index="${index}:${sub}"]`)
					$(`.tag[index="${index}:${sub}"]`).parent().parent().hide()
				}
			}
			else
			{
				for (let line_number = 1; line_number <= lines_count; line_number++)
				{
					let index = (Number(item.index) + app_sw_config.index_multiply*(line_number-1)).toString(16).toUpperCase()
					let sub = item.sub
					//console.log(`.tag[index="${index}:${sub}"]`)
					$(`.tag[index="${index}:${sub}"]`).parent().parent().hide()
				}
			}
			
		})
	}
}

function get_heat_lines_header(number)
{
	return $(`<div class="accordion-header">${l100n.localize_string("Heating Line")} ${number}</div>`)
}


// models "HCR_01F", "HCR_03F", "HCR_06FV2", "RMO", other("MCU_MW", "MCU_T", "MCU_M")
function get_heat_lines_body(number, control_mode_number)
{
	
	let model = app_sw_config.device_name
	console.log(model)
	let index_multiply = app_sw_config.index_multiply
    let ul = $('<ul>')
	let table = $('<table class="line-params-table">')

	ul.append($(`<li><a href="#live-view-tab${number}">${l100n.localize_string("Live View")}</a></li>`))
	let live_view = $(`<tbody id="live-view-tab${number}">`)
	live_view.append(`<tr class="table_header"><td class="name" colspan="2">${l100n.localize_string("Line")} ${number}</td></tr>`)
	live_view.append(common.form_tag_tr(l100n.localize_string("Name"), 0xB000 + index_multiply*(number-1), 1).addClass('heat_line_tr'))
	let alarm_trip_preset = {name: l100n.localize_string("Alarm or Trip Present"), index: 0xB001 + index_multiply*(number-1), sub: 1, type: "boolean_alarm"}
	live_view.append(common.form_tag_tr_param(alarm_trip_preset))
	live_view.append(common.form_tag_tr(l100n.localize_string("Actual Control Mode"), 0xB001 + index_multiply*(number-1), 2))
	let safe_mode = {name: l100n.localize_string("Safe Mode"), index: 0xB001 + index_multiply*(number-1), sub: 3, type: "boolean_alarm"}
	live_view.append(common.form_tag_tr_param(safe_mode))
	let output_mode = {name: l100n.localize_string("Output State"), index: 0xB001 + index_multiply*(number-1), sub: 4, type: "boolean_output"}
	live_view.append(common.form_tag_tr_param(output_mode))
	live_view.append(common.form_tag_tr(l100n.localize_string("Output Channel Status"), 0x3F0F , number))
	live_view.append(`<tr class="table_header"><td colspan="2">${l100n.localize_string("Temperature PV")}</td></tr>`)
	live_view.append(common.form_tag_tr(l100n.localize_string("Process Temperature"), 0xB010 + index_multiply*(number-1), 1))
	live_view.append(common.form_tag_tr(l100n.localize_string("Temperature 1 C"), 0xB010 + index_multiply*(number-1), 2))
	live_view.append(common.form_tag_tr(l100n.localize_string("Temperature 2 C"), 0xB010 + index_multiply*(number-1), 3))
	live_view.append(common.form_tag_tr(l100n.localize_string("Temperature Limiter C"), 0xB010 + index_multiply*(number-1), 4))
	if (model != "RMO")
    {
		live_view.append(`<tr class="table_header"><td colspan="2">${l100n.localize_string("Current PV")}</td></tr>`)
		live_view.append(common.form_tag_tr(l100n.localize_string("Load Current"), 0xB011 + index_multiply*(number-1), 1))
		live_view.append(common.form_tag_tr(l100n.localize_string("Leakage Current"), 0xB011 + index_multiply*(number-1), 2))
	}
	live_view.append(`<tr class="table_header"><td colspan="2">${l100n.localize_string("Misc PV")}</td></tr>`)
	live_view.append(common.form_tag_tr(l100n.localize_string("PWM Duty Cycle"), 0xB014 + index_multiply*(number-1), 1))
	live_view.append(common.form_tag_tr(l100n.localize_string("Output On Count"), 0xB014 + index_multiply*(number-1), 2))
	live_view.append(common.form_tag_tr(l100n.localize_string("Running Hours"), 0xB014 + index_multiply*(number-1), 3))
	live_view.append(`<tr class="table_header"><td colspan="2">${l100n.localize_string("Heatline_Control")}</td></tr>`)
	live_view.append(common.form_tag_tr(l100n.localize_string("Heatline_Command"), 0xB020 + index_multiply*(number-1), 1))
	live_view.append(common.form_tag_tr(l100n.localize_string("Remote Output Control"), 0xB020 + index_multiply*(number-1), 2))
	table.append(live_view)

	ul.append($(`<li><a href="#alarms-tab${number}">${l100n.localize_string("Alarms")}</a></li>`))
	let alarms_trips_view = $(`<tbody id="alarms-tab${number}">`)
	alarms_trips_view.append(`<tr class="table_header"><td>${l100n.localize_string("Temperature Alarms")}</td>
		<td colspan="1">${l100n.localize_string("Alarm")}</td><td colspan="2">${l100n.localize_string("Trip")}</td></tr>`)

	alarms_trips_view.append(common.form_tag_tr_param(
		{name: l100n.localize_string("Process Temperature Fault"), index: 0xB002 + index_multiply*(number-1), sub: 2, type: "boolean_alarm"}))
	alarms_trips_view.append(common.form_tag_tr_param(
		{name: l100n.localize_string("Temperature 1 Fault"), index: 0xB002 + index_multiply*(number-1), sub: 3, type: "boolean_alarm"}))
	alarms_trips_view.append(common.form_tag_tr2_param(
		{name: l100n.localize_string("Temperature 1 High"), index: 0xB002 + index_multiply*(number-1), sub: 4, type: "boolean_alarm"}, 
		{name: "", index: 0xB007 + index_multiply*(number-1), sub: 2, type: "boolean_alarm"}))
	alarms_trips_view.append(common.form_tag_tr_param(
		{name: l100n.localize_string("Temperature 1 Low"), index: 0xB002 + index_multiply*(number-1), sub: 5, type: "boolean_alarm"}))
	alarms_trips_view.append(common.form_tag_tr_param(
		{name: l100n.localize_string("Temperature 2 Fault"), index: 0xB002 + index_multiply*(number-1), sub: 6, type: "boolean_alarm"}))
	alarms_trips_view.append(common.form_tag_tr2_param(
		{name: l100n.localize_string("Temperature 2 High"), index: 0xB002 + index_multiply*(number-1), sub: 7, type: "boolean_alarm"}, 
		{name: "", index: 0xB007 + index_multiply*(number-1), sub: 3, type: "boolean_alarm"}))
	alarms_trips_view.append(common.form_tag_tr_param(
		{name: l100n.localize_string("Temperature 2 Low"), index: 0xB002 + index_multiply*(number-1), sub: 8, type: "boolean_alarm"}))

	alarms_trips_view.append(`<tr class="table_header"><td>${l100n.localize_string("Temperature Limiter C")}</td>
		<td colspan="1">${l100n.localize_string("Alarm")}</td><td colspan="2">${l100n.localize_string("Trip")}</td></tr>`)		
	alarms_trips_view.append(common.form_tag_tr_param(
		{name: l100n.localize_string("Temperature Limiter Fault"), index: 0xB002 + index_multiply*(number-1), sub: 9, type: "boolean_alarm"}))
	alarms_trips_view.append(common.form_tag_tr2_param(
		{name: l100n.localize_string("Temperature Limiter High"), index: 0xB002 + index_multiply*(number-1), sub: 10, type: "boolean_alarm"}, 
		{name: "", index: 0xB007 + index_multiply*(number-1), sub: 4, type: "boolean_alarm"}))
	if (model != "RMO")
    {
		alarms_trips_view.append(`<tr class="table_header"><td>${l100n.localize_string("Current Alarms")}</td>
			<td colspan="1">${l100n.localize_string("Alarm")}</td><td colspan="2">${l100n.localize_string("Trip")}</td></tr>`)
		alarms_trips_view.append(common.form_tag_tr2_param(
			{name: l100n.localize_string("Load Current High"), index: 0xB003 + index_multiply*(number-1), sub: 2, type: "boolean_alarm"}, 
			{name: "", index: 0xB008 + index_multiply*(number-1), sub: 2, type: "boolean_alarm"}))
		alarms_trips_view.append(common.form_tag_tr_param(
			{name: l100n.localize_string("Load Current Low"), index: 0xB003 + index_multiply*(number-1), sub: 3, type: "boolean_alarm"}))
		alarms_trips_view.append(common.form_tag_tr2_param(
			{name: l100n.localize_string("Leakage Current High"), index: 0xB003 + index_multiply*(number-1), sub: 4, type: "boolean_alarm"}, 
			{name: "", index: 0xB008 + index_multiply*(number-1), sub: 3, type: "boolean_alarm"}))
		alarms_trips_view.append(common.form_tag_tr_param(
			{name: l100n.localize_string("Output Off Current High"), index: 0xB003 + index_multiply*(number-1), sub: 5, type: "boolean_alarm"}))
	}
	alarms_trips_view.append(`<tr class="table_header"><td>${l100n.localize_string("Misc Alarms")}</td>
		<td colspan="1">${l100n.localize_string("Alarm")}</td><td colspan="2"></td></tr>`)
	alarms_trips_view.append(common.form_tag_tr_param(
		{name: l100n.localize_string("Misconfig"), index: 0xB006 + index_multiply*(number-1), sub: 2, type: "boolean_alarm"}))
	alarms_trips_view.append(common.form_tag_tr_param(
		{name: l100n.localize_string("Circuitbreaker OF"), index: 0xB006 + index_multiply*(number-1), sub: 3, type: "boolean_alarm"}))
	alarms_trips_view.append(common.form_tag_tr_param(
		{name: l100n.localize_string("Circuitbreaker SD"), index: 0xB006 + index_multiply*(number-1), sub: 4, type: "boolean_alarm"}))
	alarms_trips_view.append(common.form_tag_tr_param(
		{name: l100n.localize_string("Contactor Fault"), index: 0xB006 + index_multiply*(number-1), sub: 5, type: "boolean_alarm"}))
	alarms_trips_view.append(common.form_tag_tr_param(
		{name: l100n.localize_string("Output On Count Alarm"), index: 0xB006 + index_multiply*(number-1), sub: 6, type: "boolean_alarm"}))
	alarms_trips_view.append(common.form_tag_tr_param(
		{name: l100n.localize_string("Running Hours Alarm"), index: 0xB006 + index_multiply*(number-1), sub: 7, type: "boolean_alarm"}))
	table.append(alarms_trips_view)

	ul.append($(`<li><a href="#alarm-settings-tab${number}">${l100n.localize_string("Alarm Settings")}</a></li>`))
	let alarm_trips_settings = $(`<tbody id="alarm-settings-tab${number}">`)
	alarm_trips_settings.append(`<tr class="table_header"><td colspan="2">${l100n.localize_string("Temperature Trips Mode")}</td></tr>`)
	alarm_trips_settings.append(common.form_tag_tr(l100n.localize_string("Temperature 1"), 0xB028 + index_multiply*(number-1), 1))
	alarm_trips_settings.append(common.form_tag_tr(l100n.localize_string("Temperature 2"), 0xB028 + index_multiply*(number-1), 2))
	alarm_trips_settings.append(common.form_tag_tr(l100n.localize_string("Temperature Limiter"), 0xB028 + index_multiply*(number-1), 3))
	if (model != "RMO")
    {
		alarm_trips_settings.append(`<tr class="table_header"><td colspan="2">${l100n.localize_string("Current Trips Enable")}</td></tr>`)
		alarm_trips_settings.append(common.form_tag_tr(l100n.localize_string("Load Current High"), 0xB029 + index_multiply*(number-1), 1))
		alarm_trips_settings.append(common.form_tag_tr(l100n.localize_string("Leakage Current High"), 0xB029 + index_multiply*(number-1), 2))
	}
	if (model == "RMO" || model == "HCR_03F")
    {
		alarm_trips_settings.append(`<tr class="table_header"><td colspan="2">${l100n.localize_string("Temperature Alarm Treshold Settings")}</td></tr>`)
		alarm_trips_settings.append(common.form_tag_tr(l100n.localize_string("Offset from Limiter (Treshold Hi)"), 0xB022 + index_multiply*(number-1), 1))
		alarm_trips_settings.append(common.form_tag_tr(l100n.localize_string("Offset from Set-point (Treshold Lo)"), 0xB022 + index_multiply*(number-1), 2))	
	}
	else
	{
		alarm_trips_settings.append(`<tr class="table_header"><td colspan="2">${l100n.localize_string("Temperature Alarm Settings")}</td></tr>`)
		alarm_trips_settings.append(common.form_tag_tr(l100n.localize_string("Temperature High"), 0xB022 + index_multiply*(number-1), 1))
		alarm_trips_settings.append(common.form_tag_tr(l100n.localize_string("Temperature Low"), 0xB022 + index_multiply*(number-1), 2))
	}
	alarm_trips_settings.append(`<tr class="table_header"><td colspan="2">${l100n.localize_string("Temperature Limiter Trip Settings")}</td></tr>`)
	alarm_trips_settings.append(common.form_tag_tr(l100n.localize_string("Temperature Limiter C"), 0xB022 + index_multiply*(number-1), 4))
	if (model != "RMO")
    {
		alarm_trips_settings.append(`<tr class="table_header"><td colspan="2">${l100n.localize_string("Current Alarm Settings")}</td></tr>`)
		alarm_trips_settings.append(common.form_tag_tr(l100n.localize_string("Load Current High") + ", A", 0xB023 + index_multiply*(number-1), 1))
		alarm_trips_settings.append(common.form_tag_tr(l100n.localize_string("Load Current Low") + ", A", 0xB023 + index_multiply*(number-1), 2))
		alarm_trips_settings.append(common.form_tag_tr(l100n.localize_string("Leakage Current High") + ", A", 0xB023 + index_multiply*(number-1), 3))
		alarm_trips_settings.append(common.form_tag_tr(l100n.localize_string("Output Off Current High") + ", A", 0xB023 + index_multiply*(number-1), 4))
	}
	alarm_trips_settings.append(`<tr class="table_header"><td colspan="2">${l100n.localize_string("Misc Alarm Settings")}</td></tr>`)
	alarm_trips_settings.append(common.form_tag_tr(l100n.localize_string("Alarm Hold Time"), 0xB026 + index_multiply*(number-1), 1))
	alarm_trips_settings.append(common.form_tag_tr(l100n.localize_string("Output On Count"), 0xB026 + index_multiply*(number-1), 2))
	alarm_trips_settings.append(common.form_tag_tr(l100n.localize_string("Running Hours"), 0xB026 + index_multiply*(number-1), 3))
	table.append(alarm_trips_settings)

	ul.append($(`<li><a href="#settings-tab${number}">${l100n.localize_string("Heatline_Settings")}</a></li>`))
	let line_settings = $(`<tbody id="settings-tab${number}">`)
	//line_settings.append(`<tr class="table_header"><td colspan="2">${l100n.localize_string("Heatline_Settings")}</td></tr>`)
	line_settings.append(`<tr class="table_header"><td colspan="2">${l100n.localize_string("Control mode settings")}</td></tr>`)
	line_settings.append(common.form_tag_tr(l100n.localize_string("alarm_enable"), 0xB021 + index_multiply*(number-1), 1))
	line_settings.append(common.form_tag_tr(l100n.localize_string("Control Mode"), 0xB021 + index_multiply*(number-1), 3))

	let line_settings_ul = $('<ul>')
	let li = []
	let line_settings_table = $('<table class="line-params-table">')
	li[combo_tabs_map.pwm.tab] = $(`<li><a href="#pwm_tab${number}">${l100n.localize_string("PWM")}</a></li>`)
	li[combo_tabs_map.pwm.tab].addClass('control_mode_tab').attr({'line': number, 'tab': combo_tabs_map.pwm.tab})
	line_settings_ul.append(li[combo_tabs_map.pwm.tab])
	let pwm_tab = $(`<tbody id="pwm_tab${number}" style="padding: 1em 0em">`)
	pwm_tab.append(`<tr class="table_header"><td colspan="2">${l100n.localize_string("PWM")}</td></tr>`)
	pwm_tab.append(common.form_tag_tr(l100n.localize_string("PWM Period"), 0xB021 + index_multiply*(number-1), 5))
	pwm_tab.append(common.form_tag_tr(l100n.localize_string("PWM Duty Cycle"), 0xB021 + index_multiply*(number-1), 6))
	line_settings_table.append(pwm_tab)

	li[combo_tabs_map.temperature.tab] = $(`<li><a href="#temperature_tab${number}">${l100n.localize_string("Temp Relay")}</a></li>`)
	li[combo_tabs_map.temperature.tab].addClass('control_mode_tab').attr({'line': number, 'tab': combo_tabs_map.temperature.tab})
	line_settings_ul.append(li[combo_tabs_map.temperature.tab])
	let temperature_tab = $(`<tbody id="temperature_tab${number}" style="padding: 1em 0em">`)
	temperature_tab.append(`<tr class="table_header"><td colspan="2">${l100n.localize_string("Temp Relay")}</td></tr>`)
	temperature_tab.append(common.form_tag_tr(l100n.localize_string("Process Temperature Calc Mode"), 0xB021 + index_multiply*(number-1), 7))
	temperature_tab.append(common.form_tag_tr(l100n.localize_string("Allow Incomplete Sensors"), 0xB021 + index_multiply*(number-1), 8))
	temperature_tab.append(common.form_tag_tr(l100n.localize_string("Process Temp Set-point C"), 0xB021 + index_multiply*(number-1), 9))
	temperature_tab.append(common.form_tag_tr(l100n.localize_string("Hysteresis Positive"), 0xB021 + index_multiply*(number-1), 10))
	temperature_tab.append(common.form_tag_tr(l100n.localize_string("Hysteresis Negative"), 0xB021 + index_multiply*(number-1), 11))
	line_settings_table.append(temperature_tab)

	li[combo_tabs_map.proportional_pwm.tab] = $(`<li><a href="#proportional_pwm_tab${number}">${l100n.localize_string("PWM Proportional")}</a></li>`)
	li[combo_tabs_map.proportional_pwm.tab].addClass('control_mode_tab').attr({'line': number, 'tab': combo_tabs_map.proportional_pwm.tab})
	line_settings_ul.append(li[combo_tabs_map.proportional_pwm.tab])
	let proportional_pwm_tab = $(`<tbody id="proportional_pwm_tab${number}" style="padding: 1em 0em">`)
	proportional_pwm_tab.append(`<tr class="table_header"><td colspan="2">${l100n.localize_string("PWM Proportional")}</td></tr>`)
	proportional_pwm_tab.append(common.form_tag_tr(l100n.localize_string("PWM Period"), 0xB021 + index_multiply*(number-1), 5))
	proportional_pwm_tab.append(common.form_tag_tr(l100n.localize_string("Proportional High Temp"), 0xB021 + index_multiply*(number-1), 12))
	proportional_pwm_tab.append(common.form_tag_tr(l100n.localize_string("Proportional High PWM Duty Cycle"), 0xB021 + index_multiply*(number-1), 13))
	proportional_pwm_tab.append(common.form_tag_tr(l100n.localize_string("Proportional Low Temp"), 0xB021 + index_multiply*(number-1), 14))
	proportional_pwm_tab.append(common.form_tag_tr(l100n.localize_string("Proportional Low PWM Duty Cycle"), 0xB021 + index_multiply*(number-1), 15))
	line_settings_table.append(proportional_pwm_tab)

	if (model == "HCR_01F" || model == "HCR_06FV2")
    {
		li[combo_tabs_map.cable.tab] = $(`<li><a href="#cable_tab${number}">${l100n.localize_string("Cable Current")}</a></li>`)
		li[combo_tabs_map.cable.tab].addClass('control_mode_tab').attr({'line': number, 'tab': combo_tabs_map.cable.tab})
		line_settings_ul.append(li[combo_tabs_map.cable.tab])
		let cable_tab = $(`<tbody id="cable_tab${number}" style="padding: 1em 0em">`)
		cable_tab.append(`<tr class="table_header"><td colspan="2">${l100n.localize_string("Cable Current")}</td></tr>`)
		cable_tab.append(common.form_tag_tr(l100n.localize_string("Measure Period"), 0xB021 + index_multiply*(number-1), 16))
		cable_tab.append(common.form_tag_tr(l100n.localize_string("Heater On Time"), 0xB021 + index_multiply*(number-1), 17))
		line_settings_table.append(cable_tab)
	}

	let active_tab = get_control_mode_active_tab(control_mode_number)
	if (active_tab != null && li[active_tab])
	{
		li[active_tab].addClass('marked')
	}

	let line_settings_div = $(`<div class="tab-class" id="line_settings_div${number}">`).append(line_settings_ul).append(line_settings_table)
	line_settings_div.tabs({active: active_tab})
	let line_settings_tr = $('<tr class="can_hide">').append($('<td colspan="2">').append(line_settings_div))
	line_settings.append(line_settings_tr)
	line_settings.append(`<tr class="table_header"><td colspan="2">${l100n.localize_string("Other settings")}</td></tr>`)
	line_settings.append(common.form_tag_tr(l100n.localize_string("Startup Delay"), 0xB021 + index_multiply*(number-1), 2))	
	line_settings.append(common.form_tag_tr(l100n.localize_string("Safe Mode"), 0xB021 + index_multiply*(number-1), 4))
	/*line_settings.append(common.form_tag_tr(l100n.localize_string("Calibration Temperature 1"), 0xB021 + index_multiply*(number-1), 18))
	line_settings.append(common.form_tag_tr(l100n.localize_string("Calibration Temperature 2"), 0xB021 + index_multiply*(number-1), 19))
	line_settings.append(common.form_tag_tr(l100n.localize_string("Calibration Current 1"), 0xB021 + index_multiply*(number-1), 20))
	line_settings.append(common.form_tag_tr(l100n.localize_string("Calibration Current 2"), 0xB021 + index_multiply*(number-1), 21))*/
	if (model != "RMO")
	{
		line_settings.append(`<tr class="table_header"><td colspan="2">${l100n.localize_string("HL DeadBand Settings")}</td></tr>`)
		line_settings.append(common.form_tag_tr(l100n.localize_string("Temperature Deadband Reference"), 0xB02A + index_multiply*(number-1), 1))
		line_settings.append(common.form_tag_tr(l100n.localize_string("Temperature Deadband"), 0xB02A + index_multiply*(number-1), 2))
		line_settings.append(common.form_tag_tr(l100n.localize_string("Current Deadband Reference"), 0xB02A + index_multiply*(number-1), 3))
		line_settings.append(common.form_tag_tr(l100n.localize_string("Current Deadband"), 0xB02A + index_multiply*(number-1), 4))
		line_settings.append(common.form_tag_tr(l100n.localize_string("Leakage Current Deadband Reference"), 0xB02A + index_multiply*(number-1), 5))
		line_settings.append(common.form_tag_tr(l100n.localize_string("Leakage Current Deadband"), 0xB02A + index_multiply*(number-1), 6))
	}
    table.append(line_settings)

	ul.append($(`<li><a href="#hw-settings-tab${number}">${l100n.localize_string("HW Settings")}</a></li>`))
	let hw_line_settings = $(`<tbody id="hw-settings-tab${number}">`)
	hw_line_settings.append(`<tr class="table_header"><td colspan="2">${l100n.localize_string("Line Settings")}</td></tr>`)
	hw_line_settings.append(common.form_tag_tr(l100n.localize_string("Output Mode"), 0x3F26, number))
	hw_line_settings.append(common.form_tag_tr(l100n.localize_string("Current Limit"), 0x3F27, number))
	hw_line_settings.append(common.form_tag_tr(l100n.localize_string("Temperature 1 Select"), 0xB02B + index_multiply*(number-1), 3))
	hw_line_settings.append(common.form_tag_tr(l100n.localize_string("Temperature 2 Select"), 0xB02B + index_multiply*(number-1), 4))
	hw_line_settings.append(common.form_tag_tr(l100n.localize_string("Temperature Limiter Select"), 0xB02B + index_multiply*(number-1), 10))
	if (model != "HCR_01F" && model != "HCR_03F" && model != "HCR_06FV2" && model != "RMO")
    {
		hw_line_settings.append(common.form_tag_tr(l100n.localize_string("Output Select"), 0xB02B + index_multiply*(number-1), 2))
		hw_line_settings.append(common.form_tag_tr(l100n.localize_string("Load_Current_input"), 0xB02B + index_multiply*(number-1), 5))
		hw_line_settings.append(common.form_tag_tr(l100n.localize_string("Leakage_Current_input"), 0xB02B + index_multiply*(number-1), 6))
		hw_line_settings.append(common.form_tag_tr(l100n.localize_string("Circuitbreaker OF input"), 0xB02B + index_multiply*(number-1), 7))
		hw_line_settings.append(common.form_tag_tr(l100n.localize_string("Circuitbreaker SD input"), 0xB02B + index_multiply*(number-1), 8))
		hw_line_settings.append(common.form_tag_tr(l100n.localize_string("Contactor input"), 0xB02B + index_multiply*(number-1), 9))
		hw_line_settings.append(common.form_tag_tr(l100n.localize_string("Alarm Output Select"), 0xB02B + index_multiply*(number-1), 11))
	}
	hw_line_settings.append(common.form_tag_tr(l100n.localize_string("Minimum Output Hold Time"), 0xB02B + index_multiply*(number-1), 1))
	if (model == "HCR_01F")
    {
        hw_line_settings.append(`<tr class="table_header"><td colspan="2">${l100n.localize_string("HW Settings")}</td></tr>`)
        hw_line_settings.append(common.form_tag_tr(l100n.localize_string("Temperature 1 Sensor Type"), 0x3F39, 1))
        hw_line_settings.append(common.form_tag_tr(l100n.localize_string("Temperature 2 Sensor Type"), 0x3F39, 2))
        hw_line_settings.append(common.form_tag_tr(l100n.localize_string("Load Current Filter Time"), 0x3F34, 3))
        hw_line_settings.append(common.form_tag_tr(l100n.localize_string("Leakage Current Filter Time"), 0x3F34, 4))
    }
    else if (model == "HCR_06FV2")
    {
        hw_line_settings.append(common.form_tag_tr(l100n.localize_string("DO Invert Polarity"), 0x3F28, number))
    }
	else if (model == "HCR_03F")
    {
		//28.04.2020 Ток линии 1, 2 и 3 соответствует 4, 5 и 6 субиндексу
		hw_line_settings.append(common.form_tag_tr(l100n.localize_string("Load Current Filter Time"), 0x3F34, number + 3))
	}
	table.append(hw_line_settings)

	//if (model != "HCR_03F" && model != "RMO") 
	if (model == "HCR_01F" || model == "HCR_06FV2") 
    {
		let calibration = $(`<tbody id="calibration-tab${number}">`)
		ul.append($(`<li><a href="#calibration-tab${number}">${l100n.localize_string("Calibration tab")}</a></li>`))

		calibration.append(`<tr class="table_header"><td colspan="2">${l100n.localize_string("Cable Current Calibration")}</td></tr>`)
		calibration.append(common.form_tag_tr(l100n.localize_string("Actual Control Mode"), 0xB001 + index_multiply*(number-1), 2))
		//calibration.append(common.form_tag_tr(l100n.localize_string("Control Mode"), 0xB021 + index_multiply*(number), 3))//0,1,6
		let control_mode_off = ($(`<input type="submit" value="${l100n.localize_string("Heater Off")}" id="control_mode_off" line_number="${number}">`))
		let control_mode_on = ($(`<input type="submit" value="${l100n.localize_string("Heater On")}" id="control_mode_on" line_number="${number}">`))
		let control_mode_cabble_current = ($(`<input type="submit" value="${l100n.localize_string("Cable Current")}" id="control_mode_cabble_current" line_number="${number}">`))
		let control_mode_name = $('<td>').text(l100n.localize_string("Control Mode")).addClass("name")
		let control_mode_buttons = $('<td>').append(control_mode_off).append(control_mode_on).append(control_mode_cabble_current)
		calibration.append($('<tr>').append(control_mode_name).append(control_mode_buttons))
		
		if (model == "HCR_01F")// || model == "RMO")
		{
			calibration.append(common.form_tag_tr(l100n.localize_string("Instant current"), 0x3F31, 5))//5 - for HCR01
		}
		else if (model == "HCR_06FV2")
		{
			calibration.append(common.form_tag_tr(l100n.localize_string("Instant current"), 0x3F31, number))
		}
		//calibration.append(common.form_tag_tr(l100n.localize_string("Measure current"), 0x3F22, (number)))
		let measure_current_button = ($(`<input type="submit" value="${l100n.localize_string("Measure current")}" id="measure_current_button" line_number="${number}">`))
		calibration.append($('<tr>').append($('<td>')).append($('<td>').append(measure_current_button)))
		calibration.append(common.form_tag_tr(l100n.localize_string("Process Temperature"), 0xB010 + index_multiply*(number-1), 1))
		calibration.append(common.form_tag_tr(l100n.localize_string("Calibration Temperature 1"), 0xB021 + index_multiply*(number-1), 18))
		calibration.append(common.form_tag_tr(l100n.localize_string("Calibration Temperature 2"), 0xB021 + index_multiply*(number-1), 19))
		calibration.append(common.form_tag_tr(l100n.localize_string("Calibration Current 1"), 0xB021 + index_multiply*(number-1), 20))
		calibration.append(common.form_tag_tr(l100n.localize_string("Calibration Current 2"), 0xB021 + index_multiply*(number-1), 21))
		table.append(calibration)
	}

	let tabs_div = $('<div class="tab-class">').append(ul).append(table)
	let body_div = $('<div class="accordion-body">').append(tabs_div)
	return body_div
}

exports.mark_control_mode_tab = function(item, value) 
{
	let li = []
	let tab_index = $(item).attr('tb_index')
	let line_number = line_number_map[tab_index]				
	li[0] = $(`.control_mode_tab[line='${line_number}'][tab='0']`)
	li[1] = $(`.control_mode_tab[line='${line_number}'][tab='1']`)
	li[2] = $(`.control_mode_tab[line='${line_number}'][tab='2']`)
	li[3] = $(`.control_mode_tab[line='${line_number}'][tab='3']`)

	for (key in li)
	{
		li[key].removeClass('marked')
	}

	let selected_tab = get_control_mode_active_tab(value)
	if (selected_tab != null)
	{
		li[selected_tab].addClass('marked')
	}
}

function get_control_mode_active_tab(control_mode_number)
{
	let active_tab = null
	for (control_mode in combo_tabs_map)
	{
		if (combo_tabs_map[control_mode].combo == control_mode_number)
		{
			active_tab = combo_tabs_map[control_mode].tab
		}
	}
	return active_tab
}

$(document).on('change', 'select', function( e ) //[tb_index="B021_3"]
{
	let tab_index = $(this).attr("tb_index")
	let line_number = line_number_map[tab_index]
	let control_mode_number = $(this).val()
	let activ_tab = get_control_mode_active_tab(control_mode_number)
	$(`#line_settings_div${line_number}`).tabs({active: activ_tab})
});

$(document).on('click', '#measure_current_button', function()
{
	let line_number = $(this).attr("line_number")
	let query = `/set_od_data.form?0x3F22_${line_number}=1`
	button_command_xhr.open('GET', query, true)
	button_command_xhr.send()
});
$(document).on('click', '#control_mode_off', function()
{
	let line_number = $(this).attr("line_number")
	let query = `/set_od_data.form?0xB${line_number-1}21_3=0`
	button_command_xhr.open('GET', query, true)
	button_command_xhr.send()
});
$(document).on('click', '#control_mode_on', function()
{
	let line_number = $(this).attr("line_number")
	let query = `/set_od_data.form?0xB${line_number-1}21_3=1`
	button_command_xhr.open('GET', query, true)
	button_command_xhr.send()
});
$(document).on('click', '#control_mode_cabble_current', function()
{
	let line_number = $(this).attr("line_number")
	let query = `/set_od_data.form?0xB${line_number-1}21_3=6`
	button_command_xhr.open('GET', query, true)
	button_command_xhr.send()
});

})(this.heat_line_common = {})
